local res = external_profile("Config/Input/Aircrafts/common_keyboard_binding.lua")
dofile("Mods/aircraft/AJS37/Cockpit/Scripts/devices.lua")
dofile("Mods/aircraft/AJS37/Cockpit/Scripts/command_defs.lua")
join(res.keyCommands,{

-- Autopilot
{combos = {{key = 'J'}}, down = 3104, cockpit_device_id = devices.ENGINEPANEL, value_down = 1.0, name = _('Autothrottle mode AFK'), category = _('Autopilot')},
{combos = {{key = 'J', reformers = {'LCtrl'}}}, down = 3402, cockpit_device_id = devices.FLIGHTDATAUNIT, value_down = 1.0,name = _('Autothrottle 12 or 15.5 alpha mode'), category = _('Autopilot')}, 
{combos = {{key = 'A'}}, down = 3302, cockpit_device_id = devices.FLIGHTDATAUNIT, value_down = 1.0,name = _('Autopilot mode ATT (Attitude hold)'), category = _('Autopilot')}, 
{combos = {{key = 'H'}}, down = 3303, cockpit_device_id = devices.FLIGHTDATAUNIT, value_down = 1.0,name = _('Autopilot mode HÖJD (Altitude Hold)'), category = _('Autopilot')}, 
{combos = {{key = 'E'}}, down = 3301, cockpit_device_id = devices.FLIGHTDATAUNIT, value_down = 1.0,name = _('SAS mode SPAK flight stabiliser'), category = _('Autopilot')}, 
{combos = {{key = "O"}}, pressed = 3305, up = 3305, cockpit_device_id  = devices.FLIGHTDATAUNIT, value_pressed = 1.0, value_up = 0.0, name = _('Roll centrering (Roll trim reset)'), category = _('Flight Control')},
{combos = {{key = 'H', reformers = {'RAlt'}}}, down = 3401, cockpit_device_id = devices.FLIGHTDATAUNIT, value_down = 1.0,name = _('HUD shift to lower position'), category = _('Navigation')}, 
{combos = {{key = "S", reformers = {'RAlt'}}}, pressed = 3404, up = 3404, cockpit_device_id = devices.FLIGHTDATAUNIT, value_pressed = 1.0, value_up = 0, name = _('Seat adjustment up'), category = _('Navigation')},
{combos = {{key = "S", reformers = {'RCtrl'}}}, pressed = 3404, up = 3404, cockpit_device_id = devices.FLIGHTDATAUNIT, value_pressed = -1.0, value_up = 0, name = _('Seat adjustment down'), category = _('Navigation')},


-- Flight Control
{combos = {{key = 'Up'}}, down = iCommandPlaneUpStart, up = iCommandPlaneUpStop, name = _('Aircraft Pitch Down'), category = _('Flight Control')},
{combos = {{key = 'Down'}}, down = iCommandPlaneDownStart, up = iCommandPlaneDownStop, name = _('Aircraft Pitch Up'), category = _('Flight Control')},
{combos = {{key = 'Left'}}, down = iCommandPlaneLeftStart, up = iCommandPlaneLeftStop, name = _('Aircraft Bank Left'), category = _('Flight Control')},
{combos = {{key = 'Right'}}, down = iCommandPlaneRightStart, up = iCommandPlaneRightStop, name = _('Aircraft Bank Right'), category = _('Flight Control')},
{combos = {{key = 'Z'}}, down = iCommandPlaneLeftRudderStart, up = iCommandPlaneLeftRudderStop, name = _('Aircraft Rudder Left'), category = _('Flight Control')},
{combos = {{key = 'X'}}, down = iCommandPlaneRightRudderStart, up = iCommandPlaneRightRudderStop, name = _('Aircraft Rudder Right'), category = _('Flight Control')},

{combos = {{key = '.', reformers = {'RCtrl'}}}, pressed = iCommandPlaneTrimUp, up = iCommandPlaneTrimStop, name = _('Trim: Nose Up'), category = _('Flight Control')},
{combos = {{key = ';', reformers = {'RCtrl'}}}, pressed = iCommandPlaneTrimDown, up = iCommandPlaneTrimStop, name = _('Trim: Nose Down'), category = _('Flight Control')},
{combos = {{key = ',', reformers = {'RCtrl'}}}, pressed = iCommandPlaneTrimLeft, up = iCommandPlaneTrimStop, name = _('Trim: Left Wing Down'), category = _('Flight Control')},
{combos = {{key = '/', reformers = {'RCtrl'}}}, pressed = iCommandPlaneTrimRight, up = iCommandPlaneTrimStop, name = _('Trim: Right Wing Down'), category = _('Flight Control')},
{combos = {{key = 'Z', reformers = {'RCtrl'}}},cockpit_device_id = devices.FLIGHTDATAUNIT,  down = 3713, up = 3713, value_down =-1.0, value_up =0.0, name = _('Trim: Rudder Left'), category = _('Flight Control')},
{combos = {{key = 'X', reformers = {'RCtrl'}}},cockpit_device_id = devices.FLIGHTDATAUNIT,  down = 3713, up = 3713, value_down =1.0, value_up =0.0, name = _('Trim: Rudder Right'), category = _('Flight Control')},

{combos = {{key = 'Left', reformers = {'RShift','RAlt','RCtrl'}}},cockpit_device_id = devices.FLIGHTDATAUNIT,  down = 3716, up = 3716, value_down =-1.0, value_up =0.0, name = _('Emergency Trim Roll Left'), category = _('Flight Control')},
{combos = {{key = 'Right', reformers = {'RShift','RAlt','RCtrl'}}},cockpit_device_id = devices.FLIGHTDATAUNIT,  down = 3716, up = 3716, value_down =1.0, value_up =0.0, name = _('Emergency Trim Roll Rght'), category = _('Flight Control')},
{combos = {{key = 'Up', reformers = {'RShift','RAlt','RCtrl'}}},cockpit_device_id = devices.FLIGHTDATAUNIT,  down = 3717, up = 3717, value_down =-1.0, value_up =0.0, name = _('Emergency Trim Pitch Up'), category = _('Flight Control')},
{combos = {{key = 'Down', reformers = {'RShift','RAlt','RCtrl'}}},cockpit_device_id = devices.FLIGHTDATAUNIT,  down = 3717, up = 3717, value_down =1.0, value_up =0.0, name = _('Emergency Trim Pitch Down'), category = _('Flight Control')},

{combos = {{key = 'Z', reformers = {'RCtrl'}}},cockpit_device_id = devices.FLIGHTDATAUNIT,  down = 3713, up = 3713, value_down =-1.0, value_up =0.0, name = _('Trim: Rudder Left'), category = _('Flight Control')},
{combos = {{key = 'X', reformers = {'RCtrl'}}},cockpit_device_id = devices.FLIGHTDATAUNIT,  down = 3713, up = 3713, value_down =1.0, value_up =0.0, name = _('Trim: Rudder Right'), category = _('Flight Control')},
{combos = {{key = 'Z', reformers = {'RAlt','RCtrl'}}},cockpit_device_id = devices.FLIGHTDATAUNIT,  down = 3712, up = 3712, value_down =-1.0, value_up =0.0, name = _('Autopilot yaw trim Left'), category = _('Autopilot')},
{combos = {{key = 'X', reformers = {'RAlt','RCtrl'}}}, cockpit_device_id = devices.FLIGHTDATAUNIT, down = 3712, up = 3712, value_down =1.0, value_up =0.0, name = _('Autopilot yaw trim Right'), category = _('Autopilot')},
{combos = {{key = 'Z', reformers = {'RShift','RAlt','RCtrl'}}}, cockpit_device_id = devices.FLIGHTDATAUNIT, down = 3714, up = 3714, value_down =-1.0, value_up =0.0, name = _('Magnetic correction left'), category = _('Navigation')},
{combos = {{key = 'X', reformers = {'RShift','RAlt','RCtrl'}}}, cockpit_device_id = devices.FLIGHTDATAUNIT, down = 3714, up = 3714, value_down =1.0, value_up =0.0, name = _('Magnetic correction right'), category = _('Navigation')},
{combos = {{key = 'H', reformers = {'RShift','RAlt','RCtrl'}}}, cockpit_device_id = devices.FLIGHTDATAUNIT, down = 3715, value_down =1.0,  name = _('Altimeter pull-out'), category = _('Navigation')},
{combos = {{key = 'G'}}, down = 3723,value_down =1,  cockpit_device_id = devices.FLIGHTDATAUNIT,  name = _('Landing Gear Up/Down'), category = _('Flight Control')},
--{combos = {{key = "O"}}, pressed = device_commands.Button_4, cockpit_device_id  = devices.SPAK, value_pressed = 1.0, name = _('Centrera trim'  , category = _('Flight Control')},

{combos = {{key = 'P', reformers = {'RAlt'}}}, down = 3001, cockpit_device_id = 7, value_down =1.0, name = _('Reversal on'), category = _('Flight Control')},
{combos = {{key = 'P', reformers = {'RShift'}}}, down = 3001, cockpit_device_id = 7, value_down =0.0, name = _('Reversal off'), category = _('Flight Control')},
--{combos = {{key = "B"}}, down = iCommandPlaneAirBrake, name = _("Luftbroms ut"), category = _("Flight Control")},
{combos = {{key = "B"}}, down = 3600, cockpit_device_id = devices.FLIGHTDATAUNIT, value_down =1.0, name = _('Airbrake out/in/force out'), category = _('Flight Control')},
{combos = {{key = 'B', reformers = {'RAlt'}}}, down = 3601, up = 3601,  cockpit_device_id= devices.FLIGHTDATAUNIT, value_down =1.0, value_up = 0.0, name = _('Airbrake out (force)'), category = _('Flight Control')},
{combos = {{key = 'B', reformers = {'RShift'}}}, down = 3602,cockpit_device_id = devices.FLIGHTDATAUNIT, value_down =1.0, name = _('Airbrake in'), category = _('Flight Control')},
{combos = {{key = "B"}}, cockpit_device_id = devices.FLIGHTDATAUNIT, down = 3600, value_down =1.0, name = _('Airbrake out/in/force out'), category = _('Flight Control')},
{combos = {{key = "W"}},  down = 3698, up = 3698, cockpit_device_id = devices.FLIGHTDATAUNIT, value_down =1.0, value_up = 0.0, name = _('Wheelbrake'), category = _('Flight Control')},
{combos = {{key = 'E', reformers = {'RShift', 'RCtrl'}}}, down = 3405, cockpit_device_id = devices.FLIGHTDATAUNIT, value_down =1.0, name = _('Ejection seat arm'), category = _('Flight Control')},
{combos = {{key = 'C', reformers = {'RShift', 'RCtrl'}}}, down = 3406, cockpit_device_id = devices.FLIGHTDATAUNIT, value_down =1.0, name = _('Canopy close'), category = _('Flight Control')},
{combos = {{key = 'C', reformers = {'RAlt', 'RCtrl'}}}, down = 3406, cockpit_device_id = devices.FLIGHTDATAUNIT, value_down =-1.0, name = _('Canopy open'), category = _('Flight Control')},
{combos={{key='E',reformers={'LCtrl'}}},down=iCommandPlaneEject,name = _('Eject (3 times)'), category = _('Flight Control')},
{combos={{key='W',reformers={'LCtrl','LAlt'}}},down = 3408, cockpit_device_id = devices.FLIGHTDATAUNIT, value_down =1.0, name = _('Parking brake'), category = _('Flight Control')},

--Navigation
{combos = {{key = "N", reformers = {"LCtrl"}}}, down = 3001, cockpit_device_id = devices.NAVIGATION, value_down = 1.0, name = _("Datapanel IN/UT Input / Output switch IN"), category = _("Navigation")},
{combos = {{key = "N", reformers = {"LShift"}}}, down = 3002, cockpit_device_id = devices.NAVIGATION, value_down = 1.0, name = _("Datapanel IN/UTInput / Output  Switch OUT (UT)"), category = _("Navigation")},
{combos = {{key = "1"}}, down = 3011, cockpit_device_id = devices.NAVIGATION, value_down = 1.0, value_up = 0, name = _("Navigationpanel Waypoint 1"), category = _("Navigation")},
{combos = {{key = "2"}}, down = 3012, cockpit_device_id = devices.NAVIGATION, value_down = 1.0, value_up = 0, name = _("Navigationpanel Waypoint 2"), category = _("Navigation")},
{combos = {{key = "3"}}, down = 3013, cockpit_device_id = devices.NAVIGATION, value_down = 1.0, value_up = 0, name = _("Navigationpanel Waypoint 3"), category = _("Navigation")},
{combos = {{key = "4"}}, down = 3014, cockpit_device_id = devices.NAVIGATION, value_down = 1.0, value_up = 0, name = _("Navigationpanel Waypoint 4"), category = _("Navigation")},
{combos = {{key = "5"}}, down = 3015, cockpit_device_id = devices.NAVIGATION, value_down = 1.0, value_up = 0, name = _("Navigationpanel Waypoint 5"), category = _("Navigation")},
{combos = {{key = "6"}}, down = 3016, cockpit_device_id = devices.NAVIGATION, value_down = 1.0, value_up = 0, name = _("Navigationpanel Waypoint 6"), category = _("Navigation")},
{combos = {{key = "7"}}, down = 3017, cockpit_device_id = devices.NAVIGATION, value_down = 1.0, value_up = 0, name = _("Navigationpanel Waypoint 7"), category = _("Navigation")},
{combos = {{key = "8"}}, down = 3018, cockpit_device_id = devices.NAVIGATION, value_down = 1.0, value_up = 0, name = _("Navigationpanel Waypoint 8"), category = _("Navigation")},
{combos = {{key = "9"}}, down = 3019, cockpit_device_id = devices.NAVIGATION, value_down = 1.0, value_up = 0, name = _("Navigationpanel Waypoint 9"), category = _("Navigation")},
{combos = {{key = "0", reformers = {"LAlt"}}}, down = 3020, cockpit_device_id = devices.NAVIGATION, value_down = 1.0, value_up = 0, name = _("Datapanel Digit 0"), category = _("Navigation")},
{combos = {{key = "1", reformers = {"LAlt"}}}, down = 3021, cockpit_device_id = devices.NAVIGATION, value_down = 1.0, value_up = 0, name = _("Datapanel Digit 1"), category = _("Navigation")},
{combos = {{key = "2", reformers = {"LAlt"}}}, down = 3022, cockpit_device_id = devices.NAVIGATION, value_down = 1.0, value_up = 0, name = _("Datapanel Digit 2"), category = _("Navigation")},
{combos = {{key = "3", reformers = {"LAlt"}}}, down = 3023, cockpit_device_id = devices.NAVIGATION, value_down = 1.0, value_up = 0, name = _("Datapanel Digit 3"), category = _("Navigation")},
{combos = {{key = "4", reformers = {"LAlt"}}}, down = 3024, cockpit_device_id = devices.NAVIGATION, value_down = 1.0, value_up = 0, name = _("Datapanel Digit 4"), category = _("Navigation")},
{combos = {{key = "5", reformers = {"LAlt"}}}, down = 3025, cockpit_device_id = devices.NAVIGATION, value_down = 1.0, value_up = 0, name = _("Datapanel Digit 5"), category = _("Navigation")},
{combos = {{key = "6", reformers = {"LAlt"}}}, down = 3026, cockpit_device_id = devices.NAVIGATION, value_down = 1.0, value_up = 0, name = _("Datapanel Digit 6"), category = _("Navigation")},
{combos = {{key = "7", reformers = {"LAlt"}}}, down = 3027, cockpit_device_id = devices.NAVIGATION, value_down = 1.0, value_up = 0, name = _("Datapanel Digit 7"), category = _("Navigation")},
{combos = {{key = "8", reformers = {"LAlt"}}}, down = 3028, cockpit_device_id = devices.NAVIGATION, value_down = 1.0, value_up = 0, name = _("Datapanel Digit 8"), category = _("Navigation")},
{combos = {{key = "9", reformers = {"LAlt"}}}, down = 3029, cockpit_device_id = devices.NAVIGATION, value_down = 1.0, value_up = 0, name = _("Datapanel Digit 9"), category = _("Navigation")},
{combos = {{key = "C", reformers = {"LShift"}}}, down = 3001, cockpit_device_id = devices.NAVIGATIONPANEL, value_down = 1.0, value_up = 0, name = _("Datapanel RENSA (Clear)"), category = _("Navigation")},
{combos = {{key = "C", reformers = {"LAlt", "LShift"}}}, down = 3101, cockpit_device_id = devices.NAVIGATIONPANEL, value_down = 1.0, name = _("Datapanel RENSA cover"), category = _("Navigation")},
{combos = {{key = "T", reformers = {"RAlt"}}}, down = 3510, cockpit_device_id = devices.FLIGHTDATAUNIT, value_down = 1.0, name = _("TILS rotary clockwise"), category = _("Navigation")},
{combos = {{key = "T", reformers = {"LAlt"}}}, down = 3510, cockpit_device_id = devices.FLIGHTDATAUNIT, value_down = -1.0, name = _("TILS rotary counterclockwise"), category = _("Navigation")},
{combos = {{key = "T", reformers = {"RAlt","RCtrl"}}}, down = 3511, cockpit_device_id = devices.FLIGHTDATAUNIT, value_down = -1.0, name = _("TILS rotary layer switch"), category = _("Navigation")},

{combos = {{key = "M"}}, down = 3212, cockpit_device_id = devices.RADAR, value_down = 1.0, name = _("Memory mode"), category = _("Radar")},
{combos = {{key = "H", reformers = {"LCtrl"}}}, down = 3213, cockpit_device_id = devices.RADAR, value_down = 1.0, name = _("Obstacle detection mode"), category = _("Radar")},
{combos = {{key = "P", reformers = {"LCtrl"}}}, down = 3214, cockpit_device_id = devices.RADAR, value_down = 1.0, name = _("Passive radar mode"), category = _("Radar")},
{pressed = 3215, up = 3215, cockpit_device_id = devices.RADAR, value_pressed = 1.0, value_up = 0.0, name = _("Radar elevation up"), category = _("Radar")},
{pressed = 3215, up = 3215, cockpit_device_id = devices.RADAR, value_pressed = -1.0, value_up = 0.0, name = _("Radar elevation down"), category = _("Radar")},

{down = 3208, cockpit_device_id = devices.RADAR, value_down = 0.0, name = _("Radar AS0"), category = _("Radar")},
{down = 3208, cockpit_device_id = devices.RADAR, value_down = 0.1, name = _("Radar AS1"), category = _("Radar")},
{down = 3208, cockpit_device_id = devices.RADAR, value_down = 0.2, name = _("Radar AS2"), category = _("Radar")},
{down = 3208, cockpit_device_id = devices.RADAR, value_down = 0.3, name = _("Radar AS3"), category = _("Radar")},
{down = 3208, cockpit_device_id = devices.RADAR, value_down = 0.4, name = _("Radar AS4"), category = _("Radar")},
{down = 3208, cockpit_device_id = devices.RADAR, value_down = 0.5, name = _("Radar AS5"), category = _("Radar")},
{down = 3208, cockpit_device_id = devices.RADAR, value_down = 0.6, name = _("Radar AS6"), category = _("Radar")},
{down = 3208, cockpit_device_id = devices.RADAR, value_down = 0.7, name = _("Radar AS7"), category = _("Radar")},
{down = 3209, cockpit_device_id = devices.RADAR, value_down = 0.0, name = _("Radar LIN"), category = _("Radar")},
{down = 3209, cockpit_device_id = devices.RADAR, value_down = 1.0, name = _("Radar LOG"), category = _("Radar")},

{down = 3924, cockpit_device_id = devices.RADAR, value_down = 1.0, name = _('Radar Increase Brightness'), category = _('Radar')},  
{down = 3924, cockpit_device_id = devices.RADAR, value_down = 0.0, name = _('Radar Decrease Brightness'), category = _('Radar')}, 

{down = 3323, cockpit_device_id = devices.RADAR, value_down = 1.0, name = _('Radar  Range Increase'), category = _('Radar')},  
{down = 3324, cockpit_device_id = devices.RADAR, value_down = 1.0, name = _('Radar  Range Decrease'), category = _('Radar')}, 
{down = 3325, cockpit_device_id = devices.RADAR, value_down = 1.0, name = _('Radar MKR Gain Increase'), category = _('Radar')}, 
{down = 3326, cockpit_device_id = devices.RADAR, value_down = 1.0, name = _('Radar MKR Gain Decrease'), category = _('Radar')}, 


--HUD
{down = 3409, cockpit_device_id = devices.FLIGHTDATAUNIT, value_down = 0.1, name = _('HUD Brightness Increase'), category = _('HUD')}, 
{down = 3409, cockpit_device_id = devices.FLIGHTDATAUNIT, value_down = -0.1, name = _('HUD Brightness Decrease'), category = _('HUD')}, 


{combos = {{key = "A", reformers = {"LCtrl","LShift"}}}, pressed = 3307, cockpit_device_id = devices.FLIGHTDATAUNIT, value_pressed = 1.0, name = _("Altimeter setting up"), category = _("Flight Data")},
{combos = {{key = "A", reformers = {"LCtrl","LAlt"}}}, pressed = 3307, cockpit_device_id = devices.FLIGHTDATAUNIT, value_pressed = -1.0, name = _("Altimeter setting down"), category = _("Flight Data")},
{combos = {{key = "A", reformers = {"LCtrl","LAlt", "LShift"}}}, down = 3715, value_down = 1.0, cockpit_device_id = devices.FLIGHTDATAUNIT, value_pressed = -1.0, name = _("Altimeter setting pull-out"), category = _("Flight Data")},
{combos = {{key = "Q", reformers = {"LCtrl"}}}, down = 3100, cockpit_device_id = devices.FLIGHTDATAUNIT, value_down = 1.0, name = _("Mode select - FK"), category = _("Mode selector")},
{combos = {{key = "Q", reformers = {"LAlt"}}}, down = 3101, cockpit_device_id = devices.FLIGHTDATAUNIT, value_down = 1.0, name = _("Mode select - BER"), category = _("Mode selector")},
{combos = {{key = "Q", reformers = {"RAlt"}}}, down = 3102, cockpit_device_id = devices.FLIGHTDATAUNIT, value_down = 1.0, name = _("Mode select - NAV"), category = _("Mode selector")},
{combos = {{key = "Q", reformers = {"RCtrl"}}}, down = 3103, cockpit_device_id = devices.FLIGHTDATAUNIT, value_down = 1.0, name = _("Mode select - ANF"), category = _("Mode selector")},
{combos = {{key = "Q", reformers = {"RShift"}}}, down = 3104, cockpit_device_id = devices.FLIGHTDATAUNIT, value_down = 1.0, name = _("Mode select - SPA"), category = _("Mode selector")},
{combos = {{key = "W", reformers = {"RCtrl"}}}, down = 3105, cockpit_device_id = devices.FLIGHTDATAUNIT, value_down = 1.0, name = _("Mode select - LANDNAV"), category = _("Mode selector")},
{combos = {{key = "W", reformers = {"RShift"}}}, down = 3106, cockpit_device_id = devices.FLIGHTDATAUNIT, value_down = 1.0, name = _("Mode select - LANDPO"), category = _("Mode selector")},
{combos = {{key = "Q", reformers = {"LCtrl","LAlt"}}}, down = 3669, cockpit_device_id = devices.FLIGHTDATAUNIT, value_down = 1.0, name = _("Mode select - turn clockwise"), category = _("Mode selector")},
{combos = {{key = "Q", reformers = {"LCtrl","LShift"}}}, down = 3669, cockpit_device_id = devices.FLIGHTDATAUNIT, value_down = -1.0, name = _("Mode select - turn counterclockwise"), category = _("Mode selector")},
{combos = {{key = "1", reformers = {"RShift"}}}, down = 3501, cockpit_device_id = devices.FLIGHTDATAUNIT, value_down = 1.0, name = _("Easy mode - Navigaton"), category = _("Mode selector")},
{combos = {{key = "2", reformers = {"RShift"}}}, down = 3502, cockpit_device_id = devices.FLIGHTDATAUNIT, value_down = 1.0, name = _("Easy mode - Landing"), category = _("Mode selector")},
{combos = {{key = "3", reformers = {"RShift"}}}, down = 3503, cockpit_device_id = devices.FLIGHTDATAUNIT, value_down = 1.0, name = _("Easy mode - Grond attack"), category = _("Mode selector")},
{combos = {{key = "4", reformers = {"RShift"}}}, down = 3504, cockpit_device_id = devices.FLIGHTDATAUNIT, value_down = 1.0, name = _("Easy mode - Air-to-air"), category = _("Mode selector")},
{combos = {{key = "X", reformers = {"RShift","RCtrl"}}}, down = 3200, cockpit_device_id = devices.FLIGHTDATAUNIT, value_down = 1.0, name = _("HÖJD CISI"), category = _("Navigation")},
{combos = {{key = "Z", reformers = {"RShift","RCtrl"}}}, down = 3201, cockpit_device_id = devices.FLIGHTDATAUNIT, value_down = 1.0, name = _("SLAV SI"), category = _("Navigation")},
{combos = {{key = "T", reformers = {"RShift","RCtrl"}}}, down = 3210, cockpit_device_id = devices.FLIGHTDATAUNIT, value_down = 1.0, name = _("Pitch gearing Automatic/Landing"), category = _("Flight Control")},
--{combos = {{key = "S", reformers = {"RShift","RCtrl"}}}, down = 3300, cockpit_device_id = devices.WEAPON_SYSTEM, value_down = 1.0, name = _("Trigger safety bracket"), category = _("Weapöns")},
--{combos = {{key = "O", reformers = {"RShift","RCtrl"}}}, down = 3315, cockpit_device_id = devices.WEAPON_SYSTEM, value_down = 1.0, name = _("Trigger"), category = _("Weapons")},
{combos = {{key = "J", reformers = {"LCtrl","LAlt"}}}, down = 3302, cockpit_device_id = devices.WEAPON_SYSTEM, value_down = 1.0, name = _("Weapon jettison Cover"), category = _("Weapons")},
{combos = {{key = "J", reformers = {"LShift","LCtrl"}}}, down = 3303, cockpit_device_id = devices.WEAPON_SYSTEM, value_down = 1.0, name = _("Weapon jettison Button"), category = _("Weapons")},
{combos = {{key = "W", reformers = {"LShift","LCtrl"}}}, down = 3969, cockpit_device_id = devices.WEAPON_SYSTEM, value_down = -1.0, name = _("Weapon selector turn clockwise"), category = _("Weapons")},
{combos = {{key = "W", reformers = {"LAlt","LCtrl"}}}, down = 3969, cockpit_device_id = devices.WEAPON_SYSTEM, value_down = 1.0, name = _("Weapon selector turn counterclockwise"), category = _("Weapons")},
{combos = {{key = "J", reformers = {"RCtrl","RAlt"}}}, down = 3402, cockpit_device_id = devices.WEAPON_SYSTEM, value_down = 1.0, name = _("Fuel tank jettison Cover"), category = _("Weapons")},
{combos = {{key = "J", reformers = {"RCtrl","RShift"}}}, down = 3320, cockpit_device_id = devices.WEAPON_SYSTEM, value_down = 1.0, name = _("Fuel tank jettison Button"), category = _("Weapons")},
{combos = {{key = "C", reformers = {"LAlt","LCtrl"}}}, down = 3314, cockpit_device_id = devices.WEAPON_SYSTEM, value_down = 1.0, name = _("IR-missile uncage"), category = _("Weapons")},
{combos = {{key = "S", reformers = {"LAlt","LCtrl"}}}, down = 3311, cockpit_device_id = devices.WEAPON_SYSTEM, value_down = 1.0, name = _("IR-missile fast select"), category = _("Weapons")},
-- {combos = {{key = "W", reformers = {"LAlt"}}}, down = 3030, cockpit_device_id = 14, value_down = 1.0, name = _("Datapanel Rotary Clockwise"), category = _("Navigation")},
-- {combos = {{key = "Q", reformers = {"LAlt"}}}, down = 3031, cockpit_device_id = 14, value_down = 1.0, name = _("Datapanel Rotary Counterclockwise"), category = _("Navigation")},

-- Motor kontroll
{combos = {{key = "F", reformers = {"LAlt"}}}, down = 3040, cockpit_device_id = 15, value_down = 1.0, name = _("Low pressure fuel valve LT Kran"), category = _("Motor")},
{combos = {{key = "I", reformers = {"LAlt"}}}, down = 3005, cockpit_device_id = devices.ENGINEPANEL, value_down = 1.0, name = _("High-pressure fuel valve (throttle to idle)"), category = _("Motor")},
{combos = {{key = "S", reformers = {"LAlt"}}}, down = 3042, up = 3043, cockpit_device_id = 15, value_down = 1.0, value_up = 1.0, name = _("Startknapp"), category = _("Motor")},
{combos = {{key = "A", reformers = {"RAlt"}}}, down = 3006, cockpit_device_id = devices.ENGINEPANEL, value_down = 1.0, name = _("Afterburner fuel valve (LTkran EBK)"), category = _("Motor")},
{combos = {{key = "M", reformers = {"RAlt"}}}, down = 3007, cockpit_device_id = devices.ENGINEPANEL, value_down = 1.0, name = _("Manual fuel regulator switch"), category = _("Motor")},
{combos = {{key = "+"}}, down = 3301, up = 3301, cockpit_device_id = devices.ENGINEPANEL, value_down = 1.0, value_up = 0.0, name = _("Throttle down"), category = _("Motor")},
{combos = {{key = "-"}}, down = 3302, up = 3302, cockpit_device_id = devices.ENGINEPANEL, value_down = 1.0, value_up = 0.0, name = _("Throttle up"), category = _("Motor")},
{combos = {{key = "I", reformers = {"RAlt"}}}, down = 3008, cockpit_device_id = devices.ENGINEPANEL, value_down = 1.0, name = _("Engine De-ice switch"), category = _("Motor")},
{combos = {{key = "R", reformers = {"RAlt"}}}, down = 3002, cockpit_device_id = devices.RADARALT, value_down = 1.0, name = _("Radar altimeter switch"), category = _("Flight Data")},

-- Weapons                                                                        
--{combos = {{key = 'C', reformers = {'LShift'}}}, down = iCommandChangeGunRateOfFire, name = _('Cannon Rate Of Fire / Cut Of Burst select'), category = _('Weapons')},

-- RADAR
-- Weapons                                                                        
{combos = {{key = 'JOY_BTN1'}}, down = iCommandPlanePickleOn,	up = iCommandPlanePickleOff, name = _('Weapon Release'), category = _('Weapons')},
{down = 3321, up = 3321, value_down = -1.0, value_up = 0.0, cockpit_device_id = devices.WEAPON_SYSTEM, name = _('Rb05 stick yaw left'), category = _('Weapons')},
{down = 3321, up = 3321, value_down = 1.0, value_up = 0.0, cockpit_device_id = devices.WEAPON_SYSTEM, name = _('Rb05 stick yaw right'), category = _('Weapons')},
{down = 3322, up = 3322, value_down = 1.0, value_up = 0.0, cockpit_device_id = devices.WEAPON_SYSTEM, name = _('Rb05 stick pitch up'), category = _('Weapons')},
{down = 3322, up = 3322, value_down = -1.0, value_up = 0.0, cockpit_device_id = devices.WEAPON_SYSTEM, name = _('Rb05 stick pitch down'), category = _('Weapons')},
{down = 3316, value_down = 1.0, cockpit_device_id = devices.WEAPON_SYSTEM, name = _('EP13 Brightness up'), category = _('Weapons')},
{down = 3316, value_down = -1.0, cockpit_device_id = devices.WEAPON_SYSTEM, name = _('EP13 Brightness down'), category = _('Weapons')},
{down = 3317, value_down = 1.0, cockpit_device_id = devices.WEAPON_SYSTEM, name = _('EP13 Contrast up'), category = _('Weapons')},
{down = 3317, value_down = -1.0, cockpit_device_id = devices.WEAPON_SYSTEM, name = _('EP13 Contrast down'), category = _('Weapons')},
{down = 3001, value_down = 1.0, cockpit_device_id = devices.COUNTERMEASURE, name = _('Fast countermeasure dispense'), category = _('Countermeasures')},
{down = 3004, value_down = 1.0, cockpit_device_id = devices.COUNTERMEASURE, name = _('Countermeasure dispense OFF'), category = _('Countermeasures')},
{down = 3003, up = 3004, value_down = 1.0, value_up = 1.0, cockpit_device_id = devices.COUNTERMEASURE, name = _('Countermeasure dispense INT'), category = _('Countermeasures')},
{down = 3002, value_down = 1.0, cockpit_device_id = devices.COUNTERMEASURE, name = _('Countermeasure dispense KONT'), category = _('Countermeasures')},
{down = 3005, value_down = 1.0, cockpit_device_id = devices.COUNTERMEASURE, name = _('Countermeasure KB Mod A'), category = _('Countermeasures')},
{down = 3006, value_down = 1.0, cockpit_device_id = devices.COUNTERMEASURE, name = _('Countermeasure KB Mod 0'), category = _('Countermeasures')},
{down = 3007, value_down = 1.0, cockpit_device_id = devices.COUNTERMEASURE, name = _('Countermeasure KB Mod 1'), category = _('Countermeasures')},
{down = 3008, value_down = 1.0, cockpit_device_id = devices.COUNTERMEASURE, name = _('Countermeasure KB Mod 2'), category = _('Countermeasures')},
{down = 3009, value_down = 1.0, cockpit_device_id = devices.COUNTERMEASURE, name = _('Countermeasure KB Mod 3'), category = _('Countermeasures')},
{down = 3010, value_down = 0.0, cockpit_device_id = devices.COUNTERMEASURE, name = _('Countermeasure KB Stråk Mod 0'), category = _('Countermeasures')},
{down = 3010, value_down = 1.0, cockpit_device_id = devices.COUNTERMEASURE, name = _('Countermeasure KB Stråk Mod 4'), category = _('Countermeasures')},
{down = 3011, value_down = 1.0, cockpit_device_id = devices.COUNTERMEASURE, name = _('Countermeasure U22 Jammer Mod 0'), category = _('Countermeasures')},
{down = 3012, value_down = 1.0, cockpit_device_id = devices.COUNTERMEASURE, name = _('Countermeasure U22 Jammer Mod A'), category = _('Countermeasures')},
{down = 3013, value_down = 1.0, cockpit_device_id = devices.COUNTERMEASURE, name = _('Countermeasure U22 Jammer Mod B'), category = _('Countermeasures')},
{down = 3014, value_down = 1.0, cockpit_device_id = devices.COUNTERMEASURE, name = _('Countermeasure U22 Jammer Mod D'), category = _('Countermeasures')},
{down = 3015, value_down = 1.0, cockpit_device_id = devices.COUNTERMEASURE, name = _('Countermeasure U22 Jammer Mod E'), category = _('Countermeasures')},
{down = 3016, value_down = 1.0, cockpit_device_id = devices.COUNTERMEASURE, name = _('Countermeasure U22 Jammer Band F'), category = _('Countermeasures')},
{down = 3017, value_down = 1.0, cockpit_device_id = devices.COUNTERMEASURE, name = _('Countermeasure U22 Jammer Band G'), category = _('Countermeasures')},
{down = 3018, value_down = 1.0, cockpit_device_id = devices.COUNTERMEASURE, name = _('Countermeasure U22 Jammer Band H'), category = _('Countermeasures')},
{down = 3019, value_down = 1.0, cockpit_device_id = devices.COUNTERMEASURE, name = _('Countermeasure U22 Jammer Band J'), category = _('Countermeasures')},
{down = 3020, value_down = 1.0, cockpit_device_id = devices.COUNTERMEASURE, name = _('Countermeasure U22 Jammer Band K'), category = _('Countermeasures')},
{down = 3001, value_down = 1.0, cockpit_device_id = devices.RWR, name = _('RWR KB Off'), category = _('Countermeasures')},
{down = 3002, value_down = 1.0, cockpit_device_id = devices.RWR, name = _('RWR KB Lights'), category = _('Countermeasures')},
{down = 3003, value_down = 1.0, cockpit_device_id = devices.RWR, name = _('RWR KB Lights/Sound'), category = _('Countermeasures')},
{combos = {{key = "R", reformers = {"LAlt","LCtrl"}}}, down = 3005, value_down = 0.1, cockpit_device_id = devices.RWR, name = _('Master Volume / Sidewinder Tone Up'), category = _('Countermeasures')},
{combos = {{key = "R", reformers = {"LAlt","RAlt"}}},down = 3005, value_down = -0.1, cockpit_device_id = devices.RWR, name = _('Master Volume / Sidewinder Tone Down'), category = _('Countermeasures')},
{down = 3001, value_down = 1.0, up = 3001, value_up = 0.0, cockpit_device_id = devices.ERRORPANEL, name = _('KONTROLL light test'), category = _('Lights')},
{down = 3001, value_down = 1.0, cockpit_device_id = devices.IFF, name = _('IK (IFF) On/Off'), category = _('Countermeasures')},
{down = 3002, value_down = 1.0, cockpit_device_id = devices.IFF, name = _('IK (IFF) Code Up'), category = _('Countermeasures')},
{down = 3002, value_down = -1.0, cockpit_device_id = devices.IFF, name = _('IK (IFF) Code Down'), category = _('Countermeasures')},
{down = 3001, value_down = 1.0, cockpit_device_id = devices.TESTRADIO2, name = _('FR22 Base selector turn right'), category = _('Radios')},
{down = 3001, value_down = -1.0, cockpit_device_id = devices.TESTRADIO2, name = _('F22 Base selector turn left'), category = _('Radios')},
{down = 3002, value_down = 0.0, cockpit_device_id = devices.TESTRADIO2, name = _('FR22 Push-button H'), category = _('Radios')},
{down = 3002, value_down = 0.05, cockpit_device_id = devices.TESTRADIO2, name = _('FR22 Push-button Special 1'), category = _('Radios')},
{down = 3002, value_down = 0.1, cockpit_device_id = devices.TESTRADIO2, name = _('FR22 Push-button Special 2'), category = _('Radios')},
{down = 3002, value_down = 0.15, cockpit_device_id = devices.TESTRADIO2, name = _('FR22 Push-button Special 3'), category = _('Radios')},
{down = 3002, value_down = 0.20, cockpit_device_id = devices.TESTRADIO2, name = _('FR22 Push-button Minus'), category = _('Radios')},
{down = 3002, value_down = 0.25, cockpit_device_id = devices.TESTRADIO2, name = _('FR22 Push-button A/G'), category = _('Radios')},
{down = 3002, value_down = 0.30, cockpit_device_id = devices.TESTRADIO2, name = _('FR22 Push-button B'), category = _('Radios')},
{down = 3002, value_down = 0.35, cockpit_device_id = devices.TESTRADIO2, name = _('FR22 Push-button C/F'), category = _('Radios')},
{down = 3002, value_down = 0.40, cockpit_device_id = devices.TESTRADIO2, name = _('FR22 Push-button C2'), category = _('Radios')},
{down = 3002, value_down = 0.45, cockpit_device_id = devices.TESTRADIO2, name = _('FR22 Push-button D/E'), category = _('Radios')},
{down = 3002, value_down = 0.50, cockpit_device_id = devices.TESTRADIO2, name = _('FR22 Push-button 0'), category = _('Radios')},
{down = 3002, value_down = 0.55, cockpit_device_id = devices.TESTRADIO2, name = _('FR22 Push-button 1'), category = _('Radios')},
{down = 3002, value_down = 0.60, cockpit_device_id = devices.TESTRADIO2, name = _('FR22 Push-button 2'), category = _('Radios')},
{down = 3002, value_down = 0.65, cockpit_device_id = devices.TESTRADIO2, name = _('FR22 Push-button 3'), category = _('Radios')},
{down = 3002, value_down = 0.70, cockpit_device_id = devices.TESTRADIO2, name = _('FR22 Push-button 4'), category = _('Radios')},
{down = 3002, value_down = 0.75, cockpit_device_id = devices.TESTRADIO2, name = _('FR22 Push-button 5'), category = _('Radios')},
{down = 3002, value_down = 0.80, cockpit_device_id = devices.TESTRADIO2, name = _('FR22 Push-button 6'), category = _('Radios')},
{down = 3002, value_down = 0.85, cockpit_device_id = devices.TESTRADIO2, name = _('FR22 Push-button 7'), category = _('Radios')},
{down = 3002, value_down = 0.90, cockpit_device_id = devices.TESTRADIO2, name = _('FR22 Push-button 8'), category = _('Radios')},
{down = 3002, value_down = 0.95, cockpit_device_id = devices.TESTRADIO2, name = _('FR22 Push-button 9'), category = _('Radios')},
{down = 3003, value_down = 1.0, cockpit_device_id = devices.TESTRADIO2, name = _('FR22 Frequency wheel 1 and 2 Up'), category = _('Radios')},
{down = 3003, value_down = -1.0, cockpit_device_id = devices.TESTRADIO2, name = _('FR22 Frequency wheel 1 and 2 Down'), category = _('Radios')},
{down = 3004, value_down = 1.0, cockpit_device_id = devices.TESTRADIO2, name = _('FR22 Frequency wheel 3 Up'), category = _('Radios')},
{down = 3004, value_down = -1.0, cockpit_device_id = devices.TESTRADIO2, name = _('FR22 Frequency wheel 3 Down'), category = _('Radios')},
{down = 3005, value_down = 1.0, cockpit_device_id = devices.TESTRADIO2, name = _('FR22 Frequency wheel 4 Up'), category = _('Radios')},
{down = 3005, value_down = -1.0, cockpit_device_id = devices.TESTRADIO2, name = _('FR22 Frequency wheel 4 Down'), category = _('Radios')},
{down = 3006, value_down = 1.0, cockpit_device_id = devices.TESTRADIO2, name = _('FR22 Frequency wheel 5 and 6 Up'), category = _('Radios')},
{down = 3006, value_down = -1.0, cockpit_device_id = devices.TESTRADIO2, name = _('FR22 Frequency wheel 5 and 6 Down'), category = _('Radios')},
{down = 3008, value_down = 1.0, cockpit_device_id = devices.TESTRADIO2, name = _('FR22 AM/FM switch'), category = _('Radios')},
{down = 3007, value_down = 1.0, cockpit_device_id = devices.TESTRADIO2, name = _('FR22 Group selector turn right'), category = _('Radios')},
{down = 3007, value_down = -1.0, cockpit_device_id = devices.TESTRADIO2, name = _('FR22 Group selector turn left'), category = _('Radios')},
{down = 3010, value_down = -1.0, cockpit_device_id = devices.TESTRADIO2, name = _('Radio function selector turn right'), category = _('Radios')},
{down = 3010, value_down = 1.0, cockpit_device_id = devices.TESTRADIO2, name = _('Radio function selector turn left'), category = _('Radios')},
{down = 3011, value_down = 1.0, cockpit_device_id = devices.TESTRADIO2, name = _('FR22 Push-to-talk'), category = _('Radios')},
{down = 3011, value_down = 1.0, cockpit_device_id = devices.TESTRADIO, name = _('FR24 Push-to-talk'), category = _('Radios')},
{down = 3012, value_down = 1.0, cockpit_device_id = devices.TESTRADIO2, name = _('Radio volume control increase'), category = _('Radios')},
{down = 3012, value_down = -1.0, cockpit_device_id = devices.TESTRADIO2, name = _('Radio volume control decrease'), category = _('Radios')},
{down = 3013, value_down = 1.0, up = 3013, value_up = 0.0, cockpit_device_id = devices.TESTRADIO2, name = _('FR24 Mute'), category = _('Radios')},


-- RADAR
{pressed = 3101, up = 3100, cockpit_device_id = devices.RADAR, value_pressed = 1.0, value_up = 1.0,name = _('Radarstick Up'), category = _('Radar')},
{pressed = 3102, up = 3100, cockpit_device_id = devices.RADAR, value_pressed = 1.0, value_up = 1.0, name = _('Radarstick Down'), category = _('Radar')},
{pressed = 3103, up = 3100, cockpit_device_id = devices.RADAR, value_pressed = 1.0, value_up = 1.0,name = _('Radarstick Left'), category = _('Radar')},
{pressed = 3104, up = 3100, cockpit_device_id = devices.RADAR, value_pressed = 1.0, value_up = 1.0, name = _('Radarstick Right'), category = _('Radar')},
{down = 3010, cockpit_device_id = devices.RADAR, value_down = 1.0, name = _('Radar range 120km'), category = _('Radar')},
{down = 3011, cockpit_device_id = devices.RADAR, value_down = 1.0, name = _('Radar range 60km'), category = _('Radar')},
{down = 3012, cockpit_device_id = devices.RADAR, value_down = 1.0, name = _('Radar range 30km'), category = _('Radar')},
{down = 3013, cockpit_device_id = devices.RADAR, value_down = 1.0, name = _('Radar range 15km'), category = _('Radar')},
{down = 3002, cockpit_device_id = devices.NAVIGATIONPANEL, value_down = 1.0, name = _("A0 Mode"), category = _("Radar")},
{down = 3002, up = 3003, cockpit_device_id = devices.NAVIGATIONPANEL, value_down = 1.0, value_up = 1.0, name = _("A0 Mode (Three position switch)"), category = _("Radar")},
{down = 3003, cockpit_device_id = devices.NAVIGATIONPANEL, value_down = 1.0, name = _("A1 Mode"), category = _("Radar")},
{down = 3004, cockpit_device_id = devices.NAVIGATIONPANEL, value_down = 1.0, name = _("A2 Mode"), category = _("Radar")},
{down = 3004, up = 3003, cockpit_device_id = devices.NAVIGATIONPANEL, value_down = 1.0, value_up = 1.0, name = _("A2 Mode (Three position switch)"), category = _("Radar")},

{down = 3005, cockpit_device_id = devices.NAVIGATIONPANEL, value_down = 1.0, name = _("T0 Fix"), category = _("Radar")},
--{down = 3005, up = 3006, cockpit_device_id = devices.NAVIGATIONPANEL, value_down = 1.0, value_up = 1.0, name = _("T0 Fix (Release T1)"), category = _("Radar")},
{down = 3006, cockpit_device_id = devices.NAVIGATIONPANEL, value_down = 1.0, name = _("T1 Fix"), category = _("Radar")},
{down = 3007, cockpit_device_id = devices.NAVIGATIONPANEL, value_down = 1.0, name = _("TV Fix"), category = _("Radar")},
--{down = 3007, up = 3006, cockpit_device_id = devices.NAVIGATIONPANEL, value_down = 1.0, value_up = 1.0, name = _("TV Fix (Release T1)"), category = _("Radar")},
{down = 3090, up = 3090, cockpit_device_id = devices.FLIGHTDATAUNIT, value_down = 1.0, value_up = 0.0, name = _("Reference button"), category = _("Navigation")},
{down = 3001, cockpit_device_id = devices.DOPPLER, value_down = 1.0, name = _("Doppler land/sea mode"), category = _("Navigation")},

-- BKS NVG MOD RUSSIAN BIRDS
{combos = {{key = 'H', reformers = {'RShift','LCtrl'}}}    , down = iCommandViewNightVisionGogglesOn , name = _('Night Vision Goggles') , category = _('Sensors')},
{combos = {{key = 'H', reformers = {'LCtrl','RCtrl'}}}, pressed = iCommandPlane_Helmet_Brightess_Up , name = _('Night Vision Goggles Gain Up') , category = _('Sensors')},
{combos = {{key = 'H', reformers = {'LAlt','RAlt'}}} , pressed = iCommandPlane_Helmet_Brightess_Down, name = _('Night Vision Goggles Gain Down'), category = _('Sensors')},



{down=3718, cockpit_device_id=devices.FLIGHTDATAUNIT, value_down=1.0, name = _('Oxygen lever'), category = _('Misc')},

-- Lights panel
{combos = {{key = 'L', reformers = {'LShift'}}}, down = 3001, cockpit_device_id = devices.LIGHTS, value_down = -1.0, name = _('Anti collision lights switch'), category = _('Lights')},
{combos = {{key = 'L', reformers = {'RCtrl'}}}, down = 3002, cockpit_device_id = devices.LIGHTS, value_down = -2.0, name = _('Navigation lights switch'), category = _('Lights')},
{combos = {{key = 'L', reformers = {'LCtrl'}}}, down = 3003, cockpit_device_id = devices.LIGHTS, value_down = -1.0, name = _('Formation lights switch'), category = _('Lights')},
{down = 3005, cockpit_device_id = devices.LIGHTS, value_down = -1.0, name = _('Position lights switch'), category = _('Lights')},
{down = 3009, cockpit_device_id = devices.LIGHTS, value_down = -1.0, name = _('Taxi/landing lights switch'), category = _('Lights')},

-- Error panel
{combos = {{key = 'V'}}, down = 3001, cockpit_device_id = devices.ERRORPANEL, value_down = 1.0,  name = _('Master caution reset'), category = _('Caution panel')},
{combos = {{key = 'V', reformers = {'LCtrl', "LShift"}}}, down = 3002, up = 3002, cockpit_device_id = devices.ERRORPANEL, value_down = 1.0, value_up = 0, name = _('Check indicator lights'), category = _('Caution panel')},
{combos = {{key = 'V', reformers = {'LShift'}}}, down = 3003, cockpit_device_id = devices.ERRORPANEL, value_down = 1.0,  name = _('Toggle caution light full/half'), category = _('Caution panel')},


-- Walkman
{down=3001, cockpit_device_id=devices.WALKMAN, value_down=1.0, name = _('Play'), category = _('Tape Player')},
{down=3002, cockpit_device_id=devices.WALKMAN, value_down=1.0, name = _('Stop'), category = _('Tape Player')},
{down=3003, cockpit_device_id=devices.WALKMAN, value_down=1.0, name = _('Fast Forward'), category = _('Tape Player')},
{down=3004, cockpit_device_id=devices.WALKMAN, value_down=1.0, name = _('Fast Backward'), category = _('Tape Player')},
{down=3005, cockpit_device_id=devices.WALKMAN, value_down=1.0, name = _('Volume Up'), category = _('Tape Player')},
{down=3006, cockpit_device_id=devices.WALKMAN, value_down=1.0, name = _('Volume Down'), category = _('Tape Player')},


-- Ground crew
{combos = {{key = 'L', reformers = {'LCtrl', "LAlt"}}},down = 3501, value_down = 1.0, cockpit_device_id = devices.WEAPON_SYSTEM, name = _('Cycle Ground Crew Loadout Selection'), category = _('Weapons')},
{combos = {{key = 'F', reformers = {'LCtrl', "LAlt"}}},down = 3502, value_down = 1.0, cockpit_device_id = devices.WEAPON_SYSTEM, name = _('Cycle Ground Crew Fuel Selection'), category = _('Weapons')},
{combos = {{key = 'R', reformers = {'LCtrl', "LAlt"}}},down = 3503, value_down = 1.0, cockpit_device_id = devices.WEAPON_SYSTEM, name = _('Cycle Ground Crew Regroup Selection'), category = _('Weapons')},
{combos = {{key = 'Enter', reformers = {'LCtrl', "LAlt"}}},down = 3504, value_down = 1.0, cockpit_device_id = devices.WEAPON_SYSTEM, name = _('Confirm Ground Crew Orders'), category = _('Weapons')},



-- test radio squelch
--{down = iCommandPlaneDropFlareOnce, up = iCommandPlaneDropChaffOnce, name = _('Test command'), category = _('Weapons')},
{combos = {{key = 'Enter', reformers = {'RCtrl'}}}, down = iCommandPlane_ShowControls, name = _('Show controls indicator'), category = _('General')},
})
return res